<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"
	language="java"%>
<%@ page import="com.maplesoft.mapleta.configuration.MapleTASystemConfiguration"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<c:set property="hideMyProfile" scope="page" var="hideMyProfile">
	<tiles:getAsString name="hideMyProfile" ignore="true" />
</c:set>
<tiles:importAttribute ignore="false" name="showlinks" scope="page" />
<%-- store the user context in page scope --%>
<c:set var="context" value="${sessionScope.context}" />
<c:set var="bb_enabled" value="${sessionScope.bb_enabled}" />

<tiles:importAttribute ignore="true" name="anonymous" scope="page" />
<tiles:useAttribute name="module" id="moduleName" />
<!--  header.jsp -->
<div id="top">
	<c:if test="${! sessionScope.bb_enabled and empty sessionScope.wsQuestionEngine}">
		<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>
		<div id="global">
			<div class="container">
			<c:if test="${ not empty context and not WS_SESSION and not ltiSession}">
				<a href="<%=request.getContextPath()%>" id="homeLink"> <fmt:message		
					key="TilesDefs.SystemHomepage.ModuleTitle" />
			</a> | 
			</c:if>
			<a href="http://www.maplesoft.com/support/help/mapleta10" target="_blank">
			<%--<a href="<%=request.getContextPath()%>/help/index.html" target="_blank">--%>
				<fmt:message key="MenuItem.help.label" /></a>
			<c:if test="${ not empty context  }">
				<c:choose>
					<c:when test="${ anonymous }">
						|
						<a href="login/login.do"> <fmt:message key="Login.Login.ModuleTitle" />
						</a>
					</c:when>
					<c:otherwise>
						<c:choose>
							<c:when test="${ (context.role.viewUser || context.role.viewProfile) and not hideMyProfile}">
							| 
							<a href="useradmin/MyProfile.do?id=<bean:write name="context" property="user.id" filter="true"/>"><tiles:getAsString
									name="user" ignore="true" /> (<bean:write name="context" property="currentRole" filter="true"/>)</a>
							</c:when>
							<c:otherwise>
							| 
							<tiles:getAsString
									name="user" ignore="true" /> (<bean:write name="context" property="currentRole" filter="true"/>)
							</c:otherwise>
						</c:choose>
						| 
						<c:choose>
							<c:when test="${WS_SESSION}">
								<a href="javascript:window.close();"><fmt:message key="MenuItem.close.label" /></a>
							</c:when>
							<c:otherwise>
								<c:choose>
									<c:when test="${ltiSession}">
										<a href="login/login.do"><fmt:message key="MenuItem.close.label" /></a>
									</c:when>
									<c:otherwise>
										<a href="logout.do"><fmt:message key="MenuItem.logout.label" /></a>
									</c:otherwise>
								</c:choose>
							</c:otherwise>
						</c:choose>
					</c:otherwise>
				</c:choose>			
			</c:if>
			</div>
		</div>
		<% } %>
		<div id="pageHeader">
			<div class="container">
			
			
				<c:choose>
					<c:when test="${(WS_SESSION or ltiSession) and context != null and not context.systemAdmin}">
						<span id="logo"><fmt:message key="TilesDefs.SystemHomepage.ModuleTitle" /></span>
					</c:when>
					<c:otherwise>
						<a href="<%=request.getContextPath()%>" id="logo"> 
							<fmt:message key="TilesDefs.SystemHomepage.ModuleTitle" />
						</a>
					</c:otherwise>
				</c:choose>
			
				<div id="titleColumn">
					<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>
					<div id="title">
						<c:if test="${context != null && context.cid != -1}">
							<c:choose>
								<c:when test="${(WS_SESSION or ltiSession) and context != null and not context.role.editClass}">
									${context.classDTO.name }
								</c:when>
								<c:otherwise>
									<a href="<%=request.getContextPath()%>/modules/ClassHomepage.do?cid=${ context.cid }">${context.classDTO.name }</a>
								</c:otherwise>
							</c:choose>
						</c:if>
					</div>
					<% } %>
					<c:if test="${not empty context && showlinks ne 'false'}">
						<tiles:insert name="menu" />
					</c:if>			
					<% if( MapleTASystemConfiguration.isOPENUW() ){ %>
						<ul class="inline pull-right">
							<c:if test="${ not empty context  }">
								<c:choose>
								<c:when test="${ anonymous }">
									<li><a href="login/login.do"><fmt:message key="Login.Login.ModuleTitle" /></a></li>
									<li><a href="login/Register.do">Create account</a></li>
								</c:when>
								<c:otherwise>
									<c:if test="${empty hideMyProfile }">
										<c:choose>
											<c:when test="${ context.role.editUser || context.role.editProfile }">
												<a href="useradmin/MyProfile.do?id=<bean:write name="context" property="user.id" filter="true"/>"><tiles:getAsString
													name="user" ignore="true" /> </a>
											</c:when>
											<c:otherwise>
												<tiles:getAsString
													name="user" ignore="true" /> 
											</c:otherwise>
										</c:choose>
									</c:if>
									<li>
										<c:choose>
											<c:when test="${WS_SESSION}">
												<a href="javascript:window.close();"><fmt:message key="MenuItem.close.label" /></a>
											</c:when>
											<c:otherwise>
												<c:choose>
													<c:when test="${ltiSession}">
														<a href="login/login.do"><fmt:message key="MenuItem.close.label" /></a>
													</c:when>
													<c:otherwise>
														<a href="logout.do"><fmt:message key="MenuItem.logout.label" /></a>
													</c:otherwise>
												</c:choose>
											</c:otherwise>
										</c:choose>
									</li>
								</c:otherwise>
								</c:choose>		
							</c:if>
							<li><a href="http://www.maplesoft.com/support/help/mapleta10">
								<fmt:message key="MenuItem.help.label" /></a></li>		
						</ul>
					<% } %>
				</div>
				<div class="span2" id="logoColumn">
					<div class="row" id="customerLogo">
					</div>
				</div>
			</div>
		</div>
		<div id="pageName">
			<div class="container">
				<% if( !MapleTASystemConfiguration.isOPENUW() ){ %>
				<h1>${moduleName}</h1>				
				<% }else{ // OPENUW %>
					<nav class="span9">
						<ul class="inline">
							<li><a href="<%=request.getContextPath()%>">Homepage</a>
							</li>
							<c:if test="${context != null && context.cid != -1}">
								<span class="divider">/</span>
								<li><a href="<%=request.getContextPath()%>/modules/ClassHomepage.do?cid=${ context.cid }">${context.classDTO.availableShortName}</a></li>
							</c:if>
						</ul>
					</nav>
					<form id="search" method="get" action="<%=request.getContextPath()%>/Search.do">
					   <input type="text" name="query" placeholder="search" class="pull-right">					
				  </form>				  
				<% } %>
			</div>
		</div>
	</c:if>



	<c:if test="${sessionScope.bb_enabled and empty sessionScope.wsQuestionEngine}">
		<div id="pageHeader" class="bbPageHeader">
			<div class="container">
				<span id="logo" class="bbLogo"><img src="modules/blackboard/edu_button_32.gif"></span>
			
				<div id="titleColumn">
					<div id="title">
						<c:if test="${context != null && context.cid != -1}">
							<c:choose>
								<c:when test="${context != null and not context.role.editClass}">
									${context.classDTO.name }
								</c:when>
								<c:otherwise>
									<a href="<%=request.getContextPath()%>/modules/ClassHomepage.do?cid=${ context.cid }">${context.classDTO.name }</a>
								</c:otherwise>
							</c:choose>
						</c:if>
					</div>
					<c:if test="${not empty context && showlinks ne 'false'}">
						<tiles:insert name="menu" />
					</c:if>			
				</div>
				<div class="span2" id="logoColumn">
					<div class="row" id="customerLogo">
					</div>
				</div>
			</div>
		</div>
		<div id="pageName">
			<div class="container">
				<h1>${moduleName}</h1>				
			</div>
		</div>
	</c:if>





</div>


