var debugWindow;

function resizeAllIFrames(height, width) {
	var ids = document.getElementsByName('iframeIds');
	for( var i=0; i<ids.length; i++) {
		var id = ids[i].value;
		resizeIframe(height, width, id);
	}
}

function resizeIframe(height, width, frameId) {
	document.getElementById(frameId).height = parseInt(height)+30;
	
	var newWidth = parseInt(width)+30;

	var ua = navigator.userAgent.toLowerCase();
	var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
	
	if(isAndroid && newWidth > 640) {
		newWidth = 640;
	}
	
	document.getElementById(frameId).width = newWidth;
}

function debugMathApp(_wpkey, _worksheet) {
	var wpkey = document.getElementById(_wpkey).value;
	var worksheet = document.getElementById(_worksheet).value;
	
  	var url = getBaseURL()+ "contentmanager/RunMathAppDebugger.do?";
  	url += "wpkey=" + wpkey;
  	url += "&worksheet=" + worksheet;
  	url += "&dispatch=display";
  	
//  	openWindow(url, "forceGrade", "scrollbars=yes,resizable=yes");
  	debugWindow = openWindow(url,"mathAppDebug",'height=700,width=600,status=yes,toolbar=no,menubar=no,location=no,scrollbars=yes,resizable=yes');
  	
  }

function doDebug() {
	document.getElementById('output').value='';

	var form = document.forms['DebuggerActionForm'];
	form.dispatch.value="debug";
	form.submit();
}

function doDebugGrade() {
	document.getElementById('output').value='';
	
	var form = document.forms['DebuggerActionForm'];
	form.dispatch.value="grade";
	form.submit();
}

function doDebugClear() {
	document.getElementById('debugCode').value='';
} 

function closePreviewWorksheet(_wpkey, _worksheet) {

	var wpkey = document.getElementById(_wpkey).value;
	var worksheet = document.getElementById(_worksheet).value;

	document.getElementById('wpkey').value = wpkey;
	document.getElementById('previewWorksheet').value = worksheet;
	
	var form = document.forms['edu_form'];
	form.actionID.value="closePreviewWorksheet";
	form.submit();
	
	if( debugWindow ) {
		debugWindow.close();
	}
}

function updateGradeType(){
	var gradeTypeTA = document.getElementById('gradeTypeTA');
	var gradeTypeMaplenet = document.getElementById('gradeTypeMaplenet');
	var maple = document.getElementById('maple');
	if (gradeTypeMaplenet.checked) {
		maple.readOnly=true;
	} else {
		maple.readOnly=false;
	}
}

function updateWorksheetType(){
	var worksheetTypeUrl = document.getElementById('worksheetTypeUrl');
	var worksheetTypeFile = document.getElementById('worksheetTypeFile');
	var worksheet = document.getElementById('worksheetURL');
	var worksheetFile = document.getElementById('worksheetFile');
	
	if (worksheetTypeUrl.checked) {
		worksheet.readOnly=false;
		worksheetFile.readOnly=true;
	} else {
		worksheetFile.readOnly=false;
		worksheet.readOnly=true;
	}
}

function chooseWorksheet(inputId) {
	var worksheetTypeFile = document.getElementById('worksheetTypeFile');
	worksheetTypeFile.checked = true;
	updateWorksheetType();
	
	browseWorksheets(inputId);
}

function showStatic(id) {
	document.getElementById("mw_frame."+ id +'-img').innerHTML = '';

	submitToIframe(id, true, true);
}

function submitToIframe(_id, _restore, _static) {

	var theForm = document.forms['edu_form'];
	if( !theForm ) {
		//when in the gradebook
		theForm = document.forms['viewSearchForm'];
	}

	var _target = "mw_frame." + _id; 
	var _action = document.getElementById("ans." + _id + ".mw").value;
	
	updateInput(theForm, "wp_key", _id);

	if( _restore ) {
		updateInput(theForm, "mw_data", _id);
	} else  {
		updateInput(theForm, "mw_specific_params", _id);
	}
	
	if( _static ) {
		updateInput(theForm, "mode", _id);
	}
	
	var oldAction = theForm.action;
	var oldTarget = theForm.target;
	
	theForm.action = _action;
	theForm.target = _target;
	theForm.submit();

	theForm.action=oldAction;
	theForm.target=oldTarget;
	
}

function updateInput(theForm, key, id) {
	var input = document.getElementById(key);
	if( !input ) {

		addHidden(theForm, key);
		input = document.getElementById(key);
	} 
	
	var qInput = document.getElementById("ans." + id + "." + key);
	if( qInput) {
		input.value = qInput.value;
	}
}

function addHidden(theForm, key) {
    // Create a hidden input element, and append it to the form:
    var input = document.createElement('input');
    input.type = 'hidden';
    input.name = key;
    input.id = key;
//    input.value = value;
    theForm.appendChild(input);
}

